<?php
/**
 * This file contains theme script, styles and other theme related functions.
 * This file can be overridden by creating a anspress directory in active theme folder.
 *
 * @license   https://www.gnu.org/licenses/gpl-2.0.txt GNU Public License
 * @author    Rahul Aryan <rah12@live.com>
 * @package   AnsPress
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Enqueue scripts.
 */
function ap_scripts_front() {
	ap_assets();

	if ( ! is_anspress() && ap_opt( 'load_assets_in_anspress_only' ) ) {
		return;
	}

	ap_enqueue_scripts();

	$custom_css = '
		#anspress .ap-q-cells{
				margin-' . ( is_rtl() ? 'right' : 'left' ) . ': ' . ( ap_opt( 'avatar_size_qquestion' ) + 10 ) . 'px;
		}
		#anspress .ap-a-cells{
				margin-' . ( is_rtl() ? 'right' : 'left' ) . ': ' . ( ap_opt( 'avatar_size_qanswer' ) + 10 ) . 'px;
		}';

	wp_add_inline_style( 'anspress-main', $custom_css );
	do_action( 'ap_enqueue' );

	$aplang = array(
		'loading'                => __( 'Loading..', 'anspress-question-answer' ),
		'sending'                => __( 'Sending request', 'anspress-question-answer' ),
		// translators: %s is file size in MB.
		'file_size_error'        => esc_attr( sprintf( __( 'File size is bigger than %s MB', 'anspress-question-answer' ), round( ap_opt( 'max_upload_size' ) / ( 1024 * 1024 ), 2 ) ) ),
		'attached_max'           => __( 'You have already attached maximum numbers of allowed attachments', 'anspress-question-answer' ),
		'commented'              => __( 'commented', 'anspress-question-answer' ),
		'comment'                => __( 'Comment', 'anspress-question-answer' ),
		'cancel'                 => __( 'Cancel', 'anspress-question-answer' ),
		'update'                 => __( 'Update', 'anspress-question-answer' ),
		'your_comment'           => __( 'Write your comment...', 'anspress-question-answer' ),
		'notifications'          => __( 'Notifications', 'anspress-question-answer' ),
		'mark_all_seen'          => __( 'Mark all as seen', 'anspress-question-answer' ),
		'search'                 => __( 'Search', 'anspress-question-answer' ),
		'no_permission_comments' => __( 'Sorry, you don\'t have permission to read comments.', 'anspress-question-answer' ),
	);

	echo '<script type="text/javascript">';
	echo 'var ajaxurl = "' . esc_url( admin_url( 'admin-ajax.php' ) ) . '",';
	echo 'ap_nonce 	= "' . esc_attr( wp_create_nonce( 'ap_ajax_nonce' ) ) . '",';
	echo 'apTemplateUrl = "' . esc_url( ap_get_theme_url( 'js-template', false, false ) ) . '";';
	echo 'apQuestionID = "' . (int) get_question_id() . '";';
	echo 'aplang = ' . wp_json_encode( $aplang ) . ';';
	echo 'disable_q_suggestion = "' . (bool) ap_opt( 'disable_q_suggestion' ) . '";';
	echo '</script>';
}
add_action( 'wp_enqueue_scripts', 'ap_scripts_front', 1 );

/**
 * Register widget positions.
 */
function ap_widgets_positions() {
	register_sidebar(
		array(
			'name'          => __( '问题内容顶部', 'anspress-question-answer' ),
			'id'            => 'ap-before',
			'before_widget' => '<div id="%1$s" class="ap-widget-pos %2$s">',
			'after_widget'  => '</div>',
			'description'   => __( '此区域中的小工具将显示在问题内容之前。', 'anspress-question-answer' ),
			'before_title'  => '<h3 class="ap-widget-title">',
			'after_title'   => '</h3>',
		)
	);

	register_sidebar(
		array(
			'name'          => __( '问题列表顶部', 'anspress-question-answer' ),
			'id'            => 'ap-top',
			'before_widget' => '<div id="%1$s" class="ap-widget-pos %2$s">',
			'after_widget'  => '</div>',
			'description'   => __( 'Widgets in this area will be shown before questions list.', 'anspress-question-answer' ),
			'before_title'  => '<h3 class="ap-widget-title">',
			'after_title'   => '</h3>',
		)
	);

	register_sidebar(
		array(
			'name'          => __( '问题侧边栏', 'anspress-question-answer' ),
			'id'            => 'ap-sidebar',
			'before_widget' => '<div id="%1$s" class="ap-widget-pos %2$s">',
			'after_widget'  => '</div>',
			'description'   => __( 'Widgets in this area will be shown in AnsPress sidebar except single question page.', 'anspress-question-answer' ),
			'before_title'  => '<h3 class="ap-widget-title">',
			'after_title'   => '</h3>',
		)
	);

	register_sidebar(
		array(
			'name'          => __( '问题正文侧边栏', 'anspress-question-answer' ),
			'id'            => 'ap-qsidebar',
			'before_widget' => '<div id="%1$s" class="ap-widget-pos %2$s">',
			'after_widget'  => '</div>',
			'description'   => __( 'Widgets in this area will be shown in single question page sidebar.', 'anspress-question-answer' ),
			'before_title'  => '<h3 class="ap-widget-title">',
			'after_title'   => '</h3>',
		)
	);

	register_sidebar(
		array(
			'name'          => __( '问题分类侧边栏', 'anspress-question-answer' ),
			'id'            => 'ap-category',
			'before_widget' => '<div id="%1$s" class="ap-widget-pos %2$s">',
			'after_widget'  => '</div>',
			'description'   => __( 'Widgets in this area will be shown in category listing page.', 'anspress-question-answer' ),
			'before_title'  => '<h3 class="ap-widget-title">',
			'after_title'   => '</h3>',
		)
	);

	register_sidebar(
		array(
			'name'          => __( '问题标签侧边栏', 'anspress-question-answer' ),
			'id'            => 'ap-tag',
			'before_widget' => '<div id="%1$s" class="ap-widget-pos %2$s">',
			'after_widget'  => '</div>',
			'description'   => __( 'Widgets in this area will be shown in tag listing page.', 'anspress-question-answer' ),
			'before_title'  => '<h3 class="ap-widget-title">',
			'after_title'   => '</h3>',
		)
	);

	register_sidebar(
		array(
			'name'          => __( '问题作者侧边栏', 'anspress-question-answer' ),
			'id'            => 'ap-author',
			'before_widget' => '<div id="%1$s" class="ap-widget-pos %2$s">',
			'after_widget'  => '</div>',
			'description'   => __( 'Widgets in this area will be shown in authors page.', 'anspress-question-answer' ),
			'before_title'  => '<h3 class="ap-widget-title">',
			'after_title'   => '</h3>',
		)
	);
}
//add_action( 'widgets_init', 'ap_widgets_positions' );

function qa_widgets_positions() {
	register_sidebar(
		array(
			'name'          => '问答正文侧边栏',
			'id'            => 'qa-sidebar',
			'description'   => '显示在问答正文侧边 ',
			'before_widget' => '<aside id="%1$s" class="widget %2$s ms" data-aos="">',
			'after_widget'  => '<div class="clear"></div></aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		)
	);

	register_sidebar(
		array(
			'name'          => '问答正文底部',
			'id'            => 'qa-footer',
			'description'   => '显示在问答正文底部 ',
			'before_widget' => '<aside id="%1$s" class="widget %2$s ms" data-aos="">',
			'after_widget'  => '<div class="clear"></div></aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		)
	);
}

add_action( 'widgets_init', 'qa_widgets_positions' );

// 修正问答菜单高亮
function remove_current_classes_for_specific_category( $classes, $item ) {
	// 是否在特定分类的页面
	if ( is_tax( 'question_category' ) ) {
		// 移除特定的类
		if ( 'category' === $item->object ) {
			$classes = array_filter($classes, function($class) {
				return !in_array($class, array( 'current-menu-item', 'current_page_item', 'current-cat', 'current-cat-parent', 'current-post-ancestor' ) );
			});
		}
	}
	return $classes;
}
if ( function_exists( 'anspress' ) ) {
	add_filter( 'nav_menu_css_class', 'remove_current_classes_for_specific_category', 10, 2 );
}

// 屏蔽搜索选择
function remove_search_filter_cat() {
	remove_filter( 'pre_get_posts', 'search_filter_cat' );
}
add_action( 'init', 'remove_search_filter_cat' );

// 面包屑
function qa_get_breadcrumbs() {
    $current_page = ap_current_page();
    $title        = ap_page_title();
    $a            = array();

    $a['base'] = array(
        'title' => ap_opt( 'base_page_title' ),
        'link'  => ap_base_page_link(),
        'order' => 0,
    );

    $current_page = $current_page ? $current_page : '';

    if ( is_question() ) {
        $a['page'] = array(
            'title' => $title,
            'link'  => get_permalink( get_question_id() ),
            'order' => 10,
        );
    } elseif ( 'base' !== $current_page && '' !== $current_page ) {
        $a['page'] = array(
            'title' => $title,
            'link'  => $current_page,
            'order' => 10,
        );
    }

    $a = apply_filters( 'ap_breadcrumbs', $a );

    return is_array( $a ) ? ap_sort_array_by_order( $a ) : array();
}

function qa_breadcrumbs() {
    $navs = qa_get_breadcrumbs();

    echo '<ul class="qa-breadcrumbs clearfix">';
    echo '<li class="qa-breadcrumbs-home"><a href="' . esc_url( home_url( '/' ) ) . '" class="apicon-home"></a></li>';
    echo '<li><i class="apicon-chevron-right"></i></li>';

    $i         = 1;
    $total_nav = count( $navs );

    foreach ( $navs as $k => $nav ) {
        if ( ! empty( $nav ) ) {
            echo '<li>';
            echo '<a href="' . esc_url( $nav['link'] ) . '">' . esc_attr( $nav['title'] ) . '</a>';
            echo '</li>';

            if ( $total_nav !== $i ) {
                echo '<li><i class="apicon-chevron-right"></i></li>';
            }
        }
        ++$i;
    }

    echo '</ul>';
}
